# 柯猿课堂互动系统

一个现代化的课堂互动系统，专为教师和培训师设计，提供公平、高效的学生选择功能。

## 🌟 功能特性

### 核心功能
- **课堂互动**: 支持单个、多个和分组点名模式
- **名单管理**: 导入/导出学生名单，支持 Excel 和 CSV 格式
- **历史记录**: 自动保存点名历史，支持查看和导出
- **音效设置**: 多种音效选择，可调节音量

### 高级工具
- **权重点名**: 为不同学生设置不同的被选中概率
- **避免重复**: 智能避免短时间内重复选择同一学生
- **条件筛选**: 根据条件筛选特定学生群体
- **统计分析**: 详细的点名统计和分析报告

### 课堂工具
- **出勤管理**: 记录学生出勤情况
- **分组功能**: 智能分组和随机配对
- **课堂互动**: 支持多种课堂互动模式

### 实用工具
- **数据导出**: 支持多种格式的数据导出
- **备份恢复**: 自动备份和数据恢复功能
- **快捷键**: 丰富的键盘快捷键支持

## 🚀 快速开始

### 环境要求
- Node.js 18.0 或更高版本
- npm 或 yarn 包管理器

### 安装步骤

1. 克隆项目
```bash
git clone <repository-url>
cd random-name-picker
```

2. 安装依赖
```bash
npm install
```

3. 启动开发服务器
```bash
npm run dev
```

4. 打开浏览器访问 `http://localhost:5173`

### 构建生产版本
```bash
npm run build
```

## 📖 使用指南

### 基本使用流程

1. **导入学生名单**
   - 点击"导入名单"按钮
   - 支持手动输入、Excel 文件或 CSV 文件导入
   - 系统会自动验证和去重

2. **开始点名**
   - 选择点名模式（单个/多个/分组）
   - 设置相关参数（如选择数量、分组大小等）
   - 点击"开始点名"按钮

3. **查看结果**
   - 点名结果会实时显示
   - 自动保存到历史记录
   - 支持导出结果

### 高级功能使用

#### 权重点名
1. 在高级工具中选择"权重点名"
2. 为不同学生设置权重值
3. 权重越高，被选中概率越大

#### 避免重复
1. 启用"避免重复"功能
2. 设置避免重复的时间间隔
3. 系统会智能避免重复选择

#### 分组功能
1. 在课堂工具中选择"智能分组"
2. 设置分组数量或每组人数
3. 系统会自动进行均衡分组

## ⚙️ 配置选项

### 音效设置
- **音效类型**: 铃声、掌声、音乐
- **音量控制**: 0-100% 可调
- **启用/禁用**: 可完全关闭音效

### 动画设置
- **动画类型**: 淡入淡出、旋转、缩放
- **动画速度**: 慢速、正常、快速
- **启用/禁用**: 可关闭所有动画效果

### 数据存储
- 所有数据自动保存到浏览器本地存储
- 支持数据导出和备份
- 支持跨设备数据同步（需要手动导入/导出）

## 🎯 键盘快捷键

| 快捷键 | 功能 |
|--------|------|
| `Ctrl+S` | 打开设置 |
| `Ctrl+H` | 显示帮助信息 |
| `Escape` | 关闭当前对话框 |

## 📁 项目结构

```
random-name-picker/
├── src/
│   ├── components/          # React 组件
│   │   ├── ui/             # 基础 UI 组件
│   │   ├── header.tsx      # 页面头部
│   │   ├── name-list-manager.tsx    # 名单管理
│   │   ├── picker-control.tsx       # 点名控制
│   │   ├── result-display.tsx       # 结果显示
│   │   ├── settings-dialog.tsx      # 设置对话框
│   │   ├── utility-tools.tsx        # 实用工具
│   │   ├── advanced-tools.tsx       # 高级工具
│   │   └── classroom-tools.tsx      # 课堂工具
│   ├── utils/              # 工具函数
│   │   └── storage.ts      # 数据存储管理
│   ├── hooks/              # 自定义 Hooks
│   ├── lib/                # 库文件
│   ├── App.tsx             # 主应用组件
│   ├── main.tsx            # 应用入口
│   └── globals.css         # 全局样式
├── public/                 # 静态资源
├── package.json            # 项目配置
└── README.md              # 项目文档
```

## 🛠️ 技术栈

- **前端框架**: React 18 + TypeScript
- **构建工具**: Vite
- **UI 库**: Tailwind CSS + shadcn/ui
- **动画库**: Framer Motion
- **图标库**: Lucide React
- **状态管理**: React Hooks
- **数据存储**: LocalStorage

## 🔧 开发指南

### 添加新功能

1. 在 `src/components/` 目录下创建新组件
2. 在相应的工具组件中集成新功能
3. 更新类型定义（如需要）
4. 添加相应的测试

### 样式规范

- 使用 Tailwind CSS 进行样式开发
- 遵循响应式设计原则
- 保持组件样式的一致性

### 代码规范

- 使用 TypeScript 进行类型检查
- 遵循 React Hooks 最佳实践
- 保持组件的单一职责原则

## 📊 数据格式

### 学生数据格式
```typescript
interface Student {
  id: string;        // 唯一标识符
  name: string;      // 学生姓名
}
```

### 点名结果格式
```typescript
interface PickResult {
  students: Student[];    // 被选中的学生
  timestamp: Date;        // 点名时间
  mode: 'single' | 'multiple' | 'group';  // 点名模式
}
```

### 设置数据格式
```typescript
interface Settings {
  soundEnabled: boolean;                    // 是否启用音效
  soundType: 'bell' | 'applause' | 'music'; // 音效类型
  volume: number;                           // 音量 (0-1)
  animationEnabled: boolean;                // 是否启用动画
  animationSpeed: 'slow' | 'normal' | 'fast'; // 动画速度
  animationType: 'fade' | 'rotate' | 'scale';  // 动画类型
}
```

## 🐛 常见问题

### Q: 导入的名单数据丢失了怎么办？
A: 系统会自动保存数据到浏览器本地存储。如果数据丢失，可能是浏览器清理了缓存。建议定期导出备份数据。

### Q: 如何确保点名的公平性？
A: 系统使用真随机算法，每次点名都是完全独立的。可以在历史记录中查看统计数据验证公平性。

### Q: 可以在移动设备上使用吗？
A: 是的，系统采用响应式设计，完全支持移动设备访问。

### Q: 如何批量导入大量学生？
A: 支持 Excel 和 CSV 文件导入，可以一次性导入数百个学生。建议使用标准格式的文件。

## 📄 许可证

本项目采用 MIT 许可证。详见 [LICENSE](LICENSE) 文件。

## 🤝 贡献指南

欢迎提交 Issue 和 Pull Request！

1. Fork 本项目
2. 创建特性分支 (`git checkout -b feature/AmazingFeature`)
3. 提交更改 (`git commit -m 'Add some AmazingFeature'`)
4. 推送到分支 (`git push origin feature/AmazingFeature`)
5. 打开 Pull Request

## 📞 联系方式

如有问题或建议，请通过以下方式联系：

- 提交[Issue](https://cnb.cool/YuanCollab-2025/Keyuan-Class-Connect/-/issues)
- 发送邮件至：[kejiyuzhe@qq.com]

---

**柯猿课堂互动系统 (Keyuan Class Connect)** - 让课堂互动更加公平高效！ 🎓
